{$A+,B-,D-,E+,F-,G-,I-,L-,N-,O-,R-,S-,V-,X-}
{$M 16384,0,655360}
program MenuWork;

uses dos;
{$I c_mrw}
{$I c_rw}
{$I c_w}

var ScreenRows:Byte;
    ScreenCols:Byte;
    ScreenColor:Byte;
    ScreenSeg:Word;
    ScreenOfs:Word;
    ScreenPage:Byte;
    ScreenCharHight:Byte;
    ScreenCursorShape:Word;
    ScreenXYPos:Word;

    ActiveColor:Byte;
    LeftMargin,RightMargin,
    TopMargin,BottomMargin:Byte;
    Nove,Stare:Okno;
    Help,OldPage:Page;
    HelpOK:Boolean;

{
 * function Color3(I,J:shortint):Byte;
 * function RGB(I,J:ShortInt):Byte;
 * procedure SetScreenDependent;
 * function ScreenXY:Word;
 * procedure BackScreenDependent;
 * procedure GotoXY(X,Y:Byte);
 * procedure WriteColorAt(S:string;C:Byte;XY:Word);
 * procedure ScreenColorNewLine;
 * procedure Beep;
 * procedure UlozStare;
 * procedure Zobraz(var Stare:Okno);
 * procedure TakePage(var P:Page);
 * procedure ShowPage(var P:Page);
 * procedure TakeHelpPage;
 * procedure MarkLastMove;
 * procedure UnMarkLastMove;
 * procedure SetMargins;
 * procedure VytvorNove;
 * procedure UlozNove;
 * procedure SetCursorShape(B:Byte);
 * procedure AllScreenBack;
 * procedure ActualScreen;
 * procedure SaveConfig;
 *  procedure WritePair;
 *  procedure EditHelp;
 * procedure MENU;
 *  function AltNaZnak(Z:word):char;
 *  procedure GotoXYCur;
 *  procedure SkrzNove(I,J:ShortInt;W:Word);
 *  procedure KresliZnakBarva(Znak:char;ActiveColor:Byte;XCur:ShortInt);
 *  procedure Ramecek;
 *  procedure HMove(K:Word);
 *   procedure HZvetsi;
 *   procedure HZmensi;
 *  procedure VMove(K:Word);
 *   procedure VZvetsi;
 *   procedure VZmensi;
 *  procedure Posouvani;
 *  procedure PosunYCur(Smer:Shortint);
 *  procedure SetBE(R:ShortInt;var B,E:ShortInt);
 *  procedure EditRowName;
 *  procedure EditMoveName;
 *  procedure Edit;
 *   procedure BackGroundLight(I,J:Shortint);
 *   procedure BackGroundDark(I,J:Shortint);
 *  procedure Substitution(R:ShortInt);
}
 function Color3(I,J:shortint):Byte;
 const Power3: array[0..5] of Byte=(1,3,9,27,81,243);
 begin
  with Celek^ do
   begin
    Color3:=((Barvy[I].Colors[(J-1) div 5]) div Power3[(J-1) mod 5])mod 3;
   end;
 end;

 function RGB(I,J:ShortInt):Byte;
 const RealColors: array [0..2,false..true] of Byte =
  ((Green,$80 or Green),(Magen,$80 or Magen),(Grey,$80));
 var B,C:Byte;
 begin
  with Celek^ do
   begin
    C:=Color3(I,J);
    B:=RealColors[C,(J>=Barvy[I].BE) and (J<=Barvy[I].EE)];
    if (B and $7F)=Green
     then RGB:=(B and $80) or TextColor
     else RGB:=B
   end
 end;

 function ScreenXY:Word;
 begin
  ScreenXY:=MemW[Seg0040:$50+2*ScreenPage];
 end;

 procedure SetScreenDependent;
 begin
   ScreenSeg         :=SegB800;
   ScreenPage        :=Mem[Seg0040:$62];
   ScreenCols        :=Mem[Seg0040:$4a];
   ScreenRows        :=Mem[Seg0040:$84]+1;
   ScreenOfs         :=MemW[Seg0040:$4e];
   ScreenCharHight   :=Mem[Seg0040:$85];
   ScreenXYPos       :=ScreenXY;
   ScreenColor       :=Mem[ScreenSeg:2*ScreenCols*(ScreenRows-1)+1];
   ScreenCursorShape :=MemW[Seg0040:$60];
   {how to test Intensity/Blinking?}
   asm                 {set Intensity, not Blinking}
    mov ax,$1003
    mov bl,0
    int $10
   end;
 end;{of SetScreenDependent}

 procedure BackScreenDependent;
 begin
  asm
   mov dx,ScreenXYPos
   mov bh,ScreenPage
   mov ah,2
   int $10
   mov cx,ScreenCursorShape
   mov ah,1
   int $10
  end
 end;

 procedure GotoXY(X,Y:Byte);
 begin
  asm
   mov dh,Y
   mov dl,X
   mov bh,ScreenPage
   mov ah,2
   int $10
  end
 end;

 procedure WriteCharAttr(C:char;A:byte);
 begin
  asm
   mov al,C
   mov bl,A
   mov cx,1
   mov bh,ScreenPage
   mov ah,9
   int $10
  end
 end;

 procedure WriteColorAt(S:string;C:byte;XY:word);
 begin
  asm
   {mov ax,ss       S je predano odkazem,
   mov es,ax    ale pred spustenim zkopirovano,
                es(=ss):bp-$100 je zacatek retezce,
                v es:di je konec retezce}
   push ds
   mov cl,ss:[bp-$100]
   xor ch,ch
   mov dx,XY
   mov bh,ScreenPage
   mov bl,C
   push bp
   mov ax,bp
   sub ax,$FF
   mov bp,ax
   mov ax,$1301
   int $10
   pop bp
   pop ds
  end
 end;

 procedure ScreenColorNewLine;
 var TempColor:Byte;
 begin
  if Hi(ScreenXY)=ScreenRows-1 then
   begin
    TempColor:=Mem[ScreenSeg:2*ScreenCols*(ScreenRows-1)+1];
    Mem[ScreenSeg:2*ScreenCols*(ScreenRows-1)+1]:=ScreenColor;
    WriteColorAt(chr(10),ScreenColor,ScreenXY);
    Mem[ScreenSeg:2*ScreenCols*(ScreenRows-2)+1]:=TempColor;
   end
  else WriteColorAt(chr(10),ScreenColor,ScreenXY);
 end;

 procedure Beep;
 begin
  write(chr(7))
 end;

 procedure UlozStare;
  {ulozi cast obrazovky, kterou prekreje MENU,  do Stare}
 var I,J:ShortInt; O:Word;
 begin
  with Celek^ do
   begin
    O:=2*TopMargin*ScreenCols+ScreenOfs+2*(LeftMargin+2);
    for I:=-1 to VSize+3 do
     begin
      for J:=-2 to HSize+3 do Stare[I,J]:= MemW[ScreenSeg:O+2*J];
      inc(O,2*ScreenCols)
     end;
   end;{with celek}
 end; {   of UlozStare}

 procedure Zobraz(var Stare:Okno);
  {navrati cast obrazovky, kterou prekrylo MENU,  na obrazovku}
 var I,J:ShortInt; O:Word;
 begin
  with Celek^ do
   begin
    O:=2*TopMargin*ScreenCols+ScreenOfs+2*(LeftMargin+2);
    for I:=-1 to VSize+3 do
     begin
      for J:=-2 to HSize+3 do MemW[ScreenSeg:O+2*J]:=Stare[I,J];
      inc(O,2*ScreenCols);
     end;
   end;{with celek}
 end; {   of NavratStare}


 procedure TakePage(var P:Page);
 var I,J:ShortInt; O:Word;
 begin
  {Ramecek neni v tuto chvili zobrazen!}
  O:=ScreenOfs;
  for I:=0 to 24 do
   begin
    for J:=0 to 79 do
     P[I,J]:=MemW[ScreenSeg:O+2*J];
    inc(O,2*ScreenCols)
   end;
 end;

 procedure ShowPage(var P:Page);
 var I,J:ShortInt; O:Word;
 begin
  {Ramecek neni v tuto chvili zobrazen!}
  O:=ScreenOfs;
  for I:=0 to 24 do
   begin
    for J:=0 to 79 do
     MemW[ScreenSeg:O+2*J]:=P[I,J];
    inc(O,2*ScreenCols)
   end;
 end;

 procedure TakeHelpPage;
 var H:file of Page;
     PomStr:string;
 begin
  if not HelpOk then
   begin
    HelpOk:=true;
    FindTeXmenu;
    PomStr:=TeXmenu+'\'+'menu.hlp';
    Assign(H,PomStr);
    {$I-}
    reset(H);
    {$I+}
    if IOResult=0 then
     begin
      Read(H,Help);
      close(H)
     end
    else
     begin
      Help:=OldPage;
      Mywriteln('   ****  Menu Error  ****');
      Mywrite('       Nemohu najit soubor: ');
      Mywriteln(PomStr);
     end;
  end;
 end;

 procedure MarkLastMove;
 var Base:Word;
 begin
  Base:=$100*TextColor;
  with Celek^ do
   begin
    case (Flag and $03) of
     0:begin
        Nove[VSize+3,HSize+2]:=Base+OTBVLine;
        Nove[VSize+2,HSize+3]:=Base+OTRHLine;
        Nove[VSize+2,HSize+2]:=Base+OLTC;
       end;
     2:;
     1:begin
         Nove[-1,HSize+2]:=Base+OTTVLine;
         Nove[0,HSize+3]:=Base+OTRHLine;
         Nove[0,HSize+2]:=Base+OLBC;
        end;
     3:begin
         Nove[-1,-1]:=Base+OTTVLine;
         Nove[0,-2]:=Base+OTLHLine;
         Nove[0,-1]:=Base+ORBC;
       end;
    end;
   end;
 end;

 procedure UnMarkLastMove;
 var Base:Word;
 begin
  Base:=$100*TextColor;
  with Celek^ do
   begin
    case (Flag and $03) of
     0:begin
        Nove[VSize+3,HSize+2]:=Base+OHLine;
        Nove[VSize+2,HSize+3]:=Base+OVLine;
        Nove[VSize+2,HSize+2]:=Base+ONoLine;
       end;
     2:;
     1:begin
         Nove[-1,HSize+2]:=Base+OHLine;
         Nove[0,HSize+3]:=Base+OVLine;
         Nove[0,HSize+2]:=Base+ONoLine;
        end;
     3:begin
         Nove[-1,-1]:=Base+OHLine;
         Nove[0,-2]:=Base+OVLine;
         Nove[0,-1]:=Base+ONoLine;
       end;
    end;
   end;
 end;

 procedure SetMargins;
 var Free,Margin:Shortint;
 begin
  with Celek^ do
   begin
    Margin:=VMargin;
    Free:=ScreenRows-VSize-Margin-5;
    if Free<0 then
     begin
      Margin:=Margin+Free;
      Free:=0;
     end;
    if Margin<0 then
     begin
      MyWriteln('Prilis mala obrazovka, redukuji VSize');
      VSize:=VSize+Margin;
      Margin:=0
     end;
    if (Flag and $01)=0 then
     begin
      BottomMargin:=Margin;
      TopMargin:=Free
     end
    else
     begin
      TopMargin:=Margin;
      BottomMargin:=Free
     end;
    Margin:=HMargin;
    Free:=ScreenCols-HSize-Margin-6;
    if Free<0 then
     begin
      Margin:=Margin+Free;
      Free:=0;
     end;
    if Margin<0 then
     begin
      MyWriteln('Prilis mala obrazovka, redukuji HSize');
      HSize:=HSize+Margin;
      Margin:=0
     end;
    if (Flag and $02)=0 then
     begin
      RightMargin:=Margin;
      LeftMargin:=Free
     end
    else
     begin
      LeftMargin:=Margin;
      RightMargin:=Free
     end;
   end;
 end;

 procedure VytvorNove;
 var I,J:ShortInt;N,H,V,Base:Word;
 begin
  SetMargins;
  with Celek^ do
   begin
    SetColors;
    ActiveColor:=TextColor;
    Base:=$100*TextColor;
    H:=Base+OHLine;
    V:=Base+OVLine;
    N:=Base+ONoLine;
    for J:=-1 to HSize+2 do
     begin
      Nove[-1,J]:=H;
      Nove[0,J]:=N;
      Nove[VSize+1,J]:=N;
      Nove[VSize+2,J]:=N;
      Nove[VSize+3,J]:=H;
     end;

    for J:=1 to Length(QuitStr) do
     Nove[VSize+2,J]:=Base+ord(QuitStr[J]);
    for J:=1 to Length(Hlavicka) do
     Nove[VSize+2,HSize-Length(Hlavicka)+J]:=Base+ord(Hlavicka[J]);

    for I:=0 to VSize+2 do
     begin
      Nove[I,-2]:=V;
      Nove[I,HSize+3]:=V;
      Nove[I,0]:=N;
      Nove[I,HSize+1]:=N;
     end;
    Nove[-1,-2]:=Base+OLTC;
    Nove[-1,HSize+3]:=Base+ORTC;
    Nove[VSize+3,-2]:=Base+OLBC;
    Nove[VSize+3,HSize+3]:=Base+ORBC;
    MarkLastMove;
    for I:=1 to VSize do
     for J:=1 to HSize do
      Nove[I,J]:=$100*RGB(I,J)+ord(Texty[I,J]);
    if YCur>VSize then YCur:=VSize+2;

    Nove[YCur,0]:=Base+ord(ZnakCursorL);
    Nove[YCur,HSize+1]:=Base+ord(ZnakCursorR);

    Base:=$100*Red;
    for I:=1 to VSize do Nove[I,-1]:=Base+ord(RowNames[I]);
    Nove[Vsize+2,-1]:=Base+ord('Q');

    Base:=$100*LBlue;
    for I:=1 to VSize do Nove[I,HSize+2]:=Base+ord(MoveNames[I]);
   end;
 end;

 procedure UlozNove;
 var I,J:ShortInt;
 begin
  with Celek^ do
   begin
    for I:=1 to VSize do
     begin
      for J:=1 to HSize do Texty[I,J]:=chr(Lo(Nove[I,J]));
      Barvy[I].BE:=1;
      for J:=1 to HSize do
       begin
        if (Hi(Nove[I,J]) and $80)<>0
         then
          begin
           Barvy[I].BE:=J;
           break
          end
       end;
      Barvy[I].EE:=1;
      for J:=HSize downto 1 do
       begin
        if (Hi(Nove[I,J]) and $80)<>0
         then
          begin
           Barvy[I].EE:=J;
           break
          end
       end;
      for J:=1 to HSize do
       case Hi(Nove[I,J]) and $7F of
        Green,Brown:WriteColor3(I,J,0);
        Magen:WriteColor3(I,J,1);
        0,Grey:WriteColor3(I,J,2);
       end;
      RowNames[I]:=chr(Lo(Nove[I,-1]));
      MoveNames[I]:=chr(Lo(Nove[I,HSize+2]))
     end;
    case Flag and $03 of
     0: begin
         VMargin:=BottomMargin;
         HMargin:=RightMargin;
        end;
     1: begin
         VMargin:=TopMargin;
         HMargin:=RightMargin;
        end;
     2: begin
         VMargin:=BottomMargin;
         HMargin:=LeftMargin;
        end;
     3: begin
         VMargin:=TopMargin;
         HMargin:=LeftMargin;
        end;
    end;
   end
 end;

 procedure SetCursorShape(B:Byte);
 var Shape:Word;
 begin
  with Celek^ do
   case B of                                     {No cursor      }
    0:begin
       Shape:=$2000;
       ActiveColor:=White
      end;
    1:begin
       if (Flag and $04)=0
        then Shape:=ScreenCharHight-1             {Over cursor   }

        else Shape:=$101*(ScreenCharHight-2)+1;   {Insert cursor _}
       ActiveColor:=TextColor
      end;
    2:begin
       if (Flag and $04)=0
        then Shape:=$100*((ScreenCharHight+1) div 2)
                    +(ScreenCharHight)             {Alt cursor    }
        else Shape:=$101*((ScreenCharHight-1) div 2)
                    +1;                            {Alt cursor    -}
       ActiveColor:=Magen
      end;
    3:begin
       if (Flag and $04)=0
        then Shape:=(ScreenCharHight-1) div 2
                                                   {CtrlCursor    }
        else Shape:=$0102;                         {              _
                                                    CtrlCursor     }
       ActiveColor:=Grey
      end;
    else
     begin
      Beep;
      exit
     end;
   end;{case}
   asm
    mov cx,Shape
    or  cx,$8080
    mov ah,1
    int $10
   end;
 end;

 procedure AllScreenBack;
 begin
  Zobraz(Stare);
  ShowPage(OldPage);
  BackScreenDependent;
 end;

 procedure ActualScreen;
 begin
  TakePage(OldPage);
  with Celek^ do
   if (Flag and $20)<>0
    then
     begin
      TakeHelpPage;
      ShowPage(Help)
     end;
  UlozStare;
  Zobraz(Nove);
  SetCursorShape(0)
 end;

 procedure SaveConfig;
 var HexDig,PomStr:string;
     f:text;
     I,J:shortint;
     OldCol3:Byte;

  procedure WritePair;
  var B:Byte;
  begin
   with Celek^ do
    begin
     B:=Color3(I,J);
     if B<>OldCol3 then
      begin
       OldCol3:=B;
       write(f,ColorChar[B])
      end;
     write(f,Texty[I,J])
    end
  end;

 begin
  AllScreenBack;
  HexDig:='0123456789ABCDEF';
  UlozNove;
  FindMenuCfg;
  PomStr:=MenuCfg;
  Assign(f,PomStr);
  {$I-}
  rewrite(f);
  {$I+}
  if IoResult=0
   then
    with Celek^ do
     begin
      writeln(f,HMargin:3,'  HMargin       - chr(223)');
      writeln(f,HSize:3,  '  HSize         - chr(219)');
      writeln(f,VMargin:3,'  VMargin       - chr(220)');
      writeln(f,VSize:3,  '  VSize         - chr(175)');
      writeln(f,YCur:3,   '  YCur          - chr(174)');
      writeln(f,'$'+HexDig[1+(Flag div $10)]+HexDig[1+(Flag mod $10)]
      ,'  Flag (0,Talk,Help,End,JustExec,Insert,LastLeft,LastUp)');
      for I:=1 to VSize do
       begin
        Str(I:1,PomStr);PomStr:=copy('00',1,2-Length(PomStr))+PomStr;
        write(f,PomStr+'='+RowNames[I]+' '+MoveNames[I]+' ');
        OldCol3:=0;
        for J:=1 to Barvy[I].BE-1 do WritePair;
        write(f,'');
        for J:=Barvy[I].BE to Barvy[I].EE do WritePair;
        write(f,'');
        OldCol3:=0;
        for J:=Barvy[I].EE+1 to HSize do WritePair;
        writeln(f)
       end;
      close(f)
     end
   else
    begin
     Writeln('   ****  Menu Error  ****');
     Write('  Nemohu otevrit pro zapis soubor: ');
     Writeln(PomStr);
    end;
  ActualScreen;
 end;

procedure EditHelp;
var A,I,J:Byte;f:file of page;Konec:Boolean;K:Word;line:string;
begin
 FindTeXmenu;
 assign(f,TeXmenu+'\menu.hlp');
 reset(f);
 read(f,Help);
 close(f);
 SetScreenDependent;
 ShowPage(Help);
 I:=0;J:=0;A:=8;
 GotoXY(J,I);Konec:=false;
 repeat
  K:=ReadKey;
  case K of
   Key_Lt:if J>0
           then dec(J)
           else J:=79;
   Key_Rt:if J<79
           then inc(J)
           else J:=0;
   Key_Up:if I>0
           then dec(I)
           else I:=24;
   Key_Dn:if I<24
           then inc(I)
           else I:=0;
   Ctrl_Lt:dec(Mem[ScreenSeg:ScreenOfs+2*I*ScreenCols+2*J+1]);
   Ctrl_Rt:inc(Mem[ScreenSeg:ScreenOfs+2*I*ScreenCols+2*J+1]);
   Ctrl_Dn:begin dec(A);Mem[ScreenSeg:ScreenOfs+2*I*ScreenCols+2*J+1]:=A end;
   Ctrl_Up:begin inc(A);Mem[ScreenSeg:ScreenOfs+2*I*ScreenCols+2*J+1]:=A end;
   Escape,ShiftF1: begin
             ShowPage(OldPage);
             Exit
            end;
   F2:Konec:=true;
   else
    begin
     WriteCharAttr(chr(Hi(K)),A);
     if J<79 then inc(J)
      else
       begin
        J:=0;
        if I<24 then inc(I)
        else I:=0
       end;
    end;
  end;
  GotoXY(J,I)
 until Konec;
 TakePage(Help);
 rewrite(f);
 write(f,Help);
 close(f);
 ShowPage(OldPage)
end;

 procedure MENU;
 var
  Key:word;                          {cteny znak}
  Konec:boolean;                     {vyskok z menu do exe casti}
  Zn:   char;
  TextR :TextRadku;
  XCur  :ShortInt;                       {BText + pozice v retezci TextR}
  R,I,J :ShortInt;
  B,Pos :Byte;
  S:String;
  SubstRows: array[1..NumberExe] of boolean;

 {nyni nasleduji procedury pouzivane jen v procedure Menu}

  function AltNaZnak(Z:word):char;
  const
    Transl:array [$10..$32] of char =
     ('Q','W','E','R','T','Y','U','I','O','P','[',']',chr(7),chr(7),
      'A','S','D','F','G','H','J','K','L',';','"','~',chr(7),'|',
      'Z','X','C','V','B','N','M');
  begin
   if (Z>$0F) and (Z<$33) then
     AltNaZnak:=Transl[Z]
   else AltNaZnak:=chr(7)
  end;

  procedure GotoXYCur;
  begin
   with Celek^ do
    GotoXY(LeftMargin+XCur+2,TopMargin+YCur+1)
  end;

  procedure SkrzNove(I,J:ShortInt;W:Word);
  begin
   Nove[I,J]:=W;
   MemW[ScreenSeg:ScreenOfs+2*ScreenCols*(TopMargin+I+1)
                           +2*(LeftMargin+J+2)]:=W
  end;

  procedure KresliZnakBarva(Znak:char;ActiveColor:Byte;XCur:ShortInt);
  begin
   with Celek^ do
    SkrzNove(YCur,XCur,$100*ActiveColor+ord(Znak));
  end;

  procedure Ramecek;
  var Base,O:Word;I,J:ShortInt;
  begin
   with Celek^ do
    begin
     Base:=$100*TextColor;
     O:=2*TopMargin*ScreenCols+ScreenOfs+2*(LeftMargin+2);
     MemW[ScreenSeg:O-4]:=Base+ODLDTC;
     for J:=-1 to HSize+2 do
      begin
       MemW[ScreenSeg:O+2*J]:=Base+ODHLine;
      end;
     MemW[ScreenSeg:O+2*(HSize+3)]:=Base+ODRDTC;
     for I:=0 to VSize+2 do
      begin
       inc(O,2*ScreenCols);
       MemW[ScreenSeg:O-4]:=Base+ODVLine;
       MemW[ScreenSeg:O+2*(HSize+3)]:=Base+ODVLine
      end;
     inc(O,2*ScreenCols);
     MemW[ScreenSeg:O-4]:=Base+ODLDBC;
     for J:=-1 to HSize+2 do
      begin
       MemW[ScreenSeg:O+2*J]:=Base+ODHLine
      end;
     MemW[ScreenSeg:O+2*(HSize+3)]:=Base+ODRDBC;
     case Flag and $03 of
       0:begin
          O:=2*((TopMargin+VSize+3)*ScreenCols
            +LeftMargin+HSize+4);
          MemW[ScreenSeg:O+2]:=Base+OTDRHLine;
          MemW[ScreenSeg:O]:=Base+OLTC;
          inc(O,2*ScreenCols);
          MemW[ScreenSeg:O]:=Base+OTDBVLine;
         end;
       1:begin
          O:=2*(TopMargin*ScreenCols+LeftMargin+HSize+4);
          MemW[ScreenSeg:O]:=Base+OTDTVLine;
          inc(O,2*ScreenCols);
          MemW[ScreenSeg:O]:=Base+OLBC;
          MemW[ScreenSeg:O+2]:=Base+OTDRHLine;
         end;
       2:begin
          O:=2*((TopMargin+VSize+3)*ScreenCols
            +LeftMargin);
          MemW[ScreenSeg:O]:=Base+OTDLHLine;
          MemW[ScreenSeg:O+2]:=Base+ORTC;
          inc(O,2*ScreenCols);
          MemW[ScreenSeg:O+2]:=Base+OTDBVLine;
         end;
       3:begin
          O:=2*(TopMargin*ScreenCols+LeftMargin);
          MemW[ScreenSeg:O+2]:=Base+OTDTVLine;
          inc(O,2*ScreenCols);
          MemW[ScreenSeg:O]:=Base+OTDLHLine;
          MemW[ScreenSeg:O+2]:=Base+ORBC;
         end;
     end;
    end;
  end;

  procedure HMove(K:Word);

   procedure HZvetsi;
   var I:ShortInt;
   begin
    with Celek^ do
     if HSize<WEdit
      then
       begin
        UlozNove;
        inc(HSize);
        for I:=1 to VSize do
         begin
          Texty[I,HSize]:=' ';
          WriteColor3(I,HSize,0)
         end;
        VytvorNove;
       end
      else Beep;
   end;

   procedure HZmensi;
   var I:ShortInt;
   begin
    with Celek^ do
     begin
      UlozNove;
      for I:=1 to VSize do
       if Texty[I,HSize]<>' '
        then
         begin
          Beep;
          exit
         end;
      if HSize=1
        then
         begin
          Beep;
          exit
         end;
      for I:=1 to VSize do
       if Barvy[I].BE=HSize
        then
         begin
          Beep;
          exit
         end;
      dec(HSize);
      VytvorNove;
     end;
   end;

  begin
   Zobraz(Stare);
   with Celek^ do
    begin
     case K of
      Key_Lt:begin
              Flag:=Flag or $02;
              if LeftMargin>0 then
               begin
                dec(LeftMargin);inc(RightMargin)
               end
              else Beep
             end;
      Key_Rt:begin
              Flag:=Flag and $FD;
              if RightMargin>0 then
               begin
                dec(RightMargin);inc(LeftMargin)
               end
              else Beep
             end;
      Ctrl_Lt:if (Flag and $02)=0
               then HZvetsi
               else HZmensi;
      Ctrl_Rt:if (Flag and $02)=0
               then HZmensi
               else HZvetsi;
     end;
    end;{with Celek}
   UlozStare
  end;

  procedure VMove(K:Word);

   procedure VZvetsi;
   begin
    with Celek^ do
     if VSize<NumberExe
      then
       begin
        UlozNove;
        if YCur>VSize then
         InsertLine(YCur-1)
        else
         InsertLine(YCur);
        VytvorNove;
       end
      else Beep;
   end;

   procedure VZmensi;
   var I:ShortInt;
   begin
    with Celek^ do
     begin
      UlozNove;
      if ZnakNaRadek(' ',I) then
       begin
        if RowNames[YCur]=' ' then I:=YCur;
        if YCur>I then dec(YCur);
        RemoveLine(I);
        VytvorNove;
       end
      else Beep
     end
   end;

  begin
   Zobraz(Stare);
   with Celek^ do
    begin
     case K of
      Key_Up:begin
              Flag:=Flag or $01;
              if TopMargin>0 then
               begin
                dec(TopMargin);inc(BottomMargin)
               end
              else Beep
             end;
      Key_Dn:begin
              Flag:=Flag and $FE;
              if BottomMargin>0 then
               begin
                dec(BottomMargin);inc(TopMargin)
               end
              else Beep
             end;
      Ctrl_Up:if (Flag and $01)=0
               then VZvetsi
               else VZmensi;
      Ctrl_Dn:if (Flag and $01)=0
               then VZmensi
               else VZvetsi;
     end;
    end;{with Celek}
   UlozStare
  end;

  procedure Posouvani;
  begin
   repeat
    UnMarkLastMove;
    Ramecek;
    Key:=ReadKey;
    case Key of
     Key_Lt,Key_Rt,Ctrl_Lt,Ctrl_Rt : HMove(Key);
     Key_Dn,Key_Up,Ctrl_Dn,Ctrl_Up : VMove(Key);
     Enter,EnterNum:Key:=Enter;
     else Beep;
    end; {case}
   until Key=Enter;
   MarkLastMove;
   Zobraz(Nove);
  end;

  procedure PosunYCur(Smer:Shortint);
      {posune Cursor v smeru -1=nahoru}
  begin
   with Celek^ do
    begin
     KresliZnakBarva(' ',TextColor,0);
     KresliZnakBarva(' ',TextColor,HSize+1);
     if YCur=VSize+2 then dec(YCur);
     YCur:=(YCur+Smer) mod (VSize+1);
     if YCur=0 then YCur:=VSize+2;
     KresliZnakBarva(ZnakCursorL,TextColor,0);
     KresliZnakBarva(ZnakCursorR,TextColor,HSize+1);
    end;{with celek}
  end; {of procedure PosunCursor}

  procedure SetBE(R:ShortInt;var B,E:ShortInt);
  var I:Byte;
  begin
   B:=1;
   with Celek^ do
    begin
     for I:=1 to HSize do
      if (Nove[R,I] and $8000)<>0 then
       begin
        B:=I;
        break
       end;
     E:=0;
     for I:=HSize downto 1 do
      if (Nove[R,I] and $8000)<>0 then
       begin
        E:=I;
        break
       end;
    end
  end;

  procedure EditRowName;
  var K:Word;
  begin
   with Celek^ do
    begin
     GotoXY(LeftMargin+1,TopMargin+YCur+1);
     K:=ReadKey;
     if (Hi(K)=0)
      then
       begin
        RowNames[YCur]:=AltNaZnak(K);
        SkrzNove(YCur,-1,$100*Red+ord(RowNames[YCur]))
       end
     else if K=Space
      then
       begin
        RowNames[YCur]:=' ';
        SkrzNove(YCur,-1,$100*Red+ord(' '))
       end
     else
      Beep
    end
  end;

  procedure EditMoveName;
  var K:Word;
  begin
   with Celek^ do
    begin
     GotoXY(LeftMargin+HSize+4,TopMargin+YCur+1);
     K:=ReadKey;
     if (Hi(K)=0)
      then
       begin
        MoveNames[YCur]:=AltNaZnak(K);
        SkrzNove(YCur,HSize+2,$100*LBlue+ord(MoveNames[YCur]))
       end
     else if K=Space
      then
       begin
        MoveNames[YCur]:=' ';
        SkrzNove(YCur,HSize+2,$100*LBlue+ord(' '))
       end
      else Beep
    end
  end;

  procedure Edit;
  var
   I,R,BText,EText:ShortInt;
   M,BCopy,ECopy:ShortInt;
   EscOk,Konec  :Boolean;          {konec editace}
   OldT,                                   {stary  radek, pro obnoveni pri Esc}
   LastT    :array [1..WEdit] of char;  {minuly radek, pro obnoveni pri Esc}
   OldName,LastName:char;
   OldMove,LastMove:char;
   OldB,
   LastB    :array [1..WEdit] of Byte;

  procedure BackGroundLight(I,J:Shortint);
  begin
   SkrzNove(I,J,Nove[I,J] or $8000);
   if Hi(Nove[I,J])=$88 then SkrzNove(I,J,Nove[I,J] and $F7FF)
  end;

  procedure BackGroundDark(I,J:Shortint);
  begin
   SkrzNove(I,J,Nove[I,J] and $7FFF);
   if Hi(Nove[I,J])=0 then SkrzNove(I,J,Nove[I,J] or $0800)
  end;

  begin{of procedure Edit}
   with Celek^ do
    begin
     Konec:=false;EscOk:=false;
     for I:=1 to HSize do
      begin
       OldT[I]:=chr(Lo(Nove[YCur,I]));
       OldB[I]:=Hi(Nove[YCur,I]);
      end;
     OldName:=chr(Lo(Nove[YCur,-1]));
     OldMove:=chr(Lo(Nove[YCur,Hsize+2]));
     SetCursorShape(1);
     ActiveColor:=TextColor;
     SetBE(YCur,BText,EText);
     if (Hi(Key)<>$00) and (Hi(Key)<>$E0)
      then
       begin
        for I:=EText to HSize do
         SkrzNove(YCur,I-(EText-BText),Nove[YCur,I]);
        for I:=HSize-(EText-BText)+1 to HSize do
         KresliZnakBarva(' ',TextColor,I);
        EText:=BText;
        KresliZnakBarva(' ',$80+TextColor,BText)
       end;
     XCur:=BText;
     if EText=0 then inc(EText);
     repeat {vlastni editace}
      case Hi(Key) of
        $E0:
         case Key of
           Key_Rt:
              if XCur<Etext
               then inc(XCur)
               else XCur:=BText;
           Ctrl_Rt:
              if XCur<HSize
               then inc(XCur)
               else XCur:=1;
           Key_Lt:
              if XCur>BText
               then dec(XCur)
               else XCur:=EText;
           Ctrl_Lt:
              if XCur>1
               then dec(XCur)
               else XCur:=HSize;
           Key_Ins:
             begin
              Flag:=Flag xor $04;
              SetCursorShape(1);
             end;
           Key_Del:
             begin
              if (BText=EText) and (XCur=BText)
               then
                KresliZnakBarva(' ',TextColor or $80,XCur)
              else
               begin
                for I:=XCur to HSize-1 do
                 begin
                  SkrzNove(YCur,I,Nove[YCur,I+1]);
                  SkrzNove(YCur,HSize,$100*TextColor+ord(' '))
                 end;
                if XCur<BText then dec(BText);
                if XCur=EText then
                 begin
                  dec(XCur);
                  dec(EText)
                 end;
                if XCur<EText then dec(EText);
               end
             end;
           Key_Home:XCur:=BText;
           Key_End: XCur:=EText;
           Ctrl_Ins:
              if ActiveColor=Grey
               then
                begin
                 ActiveColor:=TextColor;
                 SetCursorShape(1)
                end
               else
                begin
                 ActiveColor:=Grey;
                 SetCursorShape(3)
                end;
           Ctrl_Home:
             begin
              SetBE(YCur,BText,EText);
              if BText<XCur then
               for I:=BText to XCur-1 do BackGroundDark(YCur,I)
              else
               for I:=XCur to BText-1 do BackGroundLight(YCur,I);
              BText:=XCur;
              if EText<BText then
               begin
                EText:=BText;
                BackGroundLight(YCur,XCur)
               end;
             end;
           Ctrl_End:
             begin
              SetBE(YCur,BText,EText);
              if EText>XCur then
               for I:=XCur+1 to EText do BackGroundDark(YCur,I)
              else
               for I:=EText+1 to XCur do BackGroundLight(YCur,I);
              EText:=XCur;
              if EText<BText then
               begin
                BText:=EText;
                BackGroundLight(YCur,XCur)
               end;
             end;
           else Beep
         end;
        $00:
          if (Key>=AltW) and (Key<=AltM) then
           if ZnakNaRadek(AltNaZnak(Key),R) and
             (XCur>=BText) and (XCur<=EText) then
            begin
             EscOk:=true;
             for I:=1 to HSize do
              begin
               LastT[I]:=chr(Lo(Nove[YCur,I]));
               LastB[I]:=Hi(Nove[YCur,I]);
              end;
             LastName:=chr(Lo(Nove[YCur,-1]));
             LastMove:=chr(Lo(Nove[YCur,HSize+2]));
             SetBE(R,BCopy,ECopy);
             if (Flag and $04)<>0
              then
               begin
                for I:=HSize+BCopy-ECopy-1 downto XCur do
                 SkrzNove(YCur,I+ECopy-BCopy+1,Nove[YCur,I]);
                M:=HSize;
                if XCur+ECopy-BCopy<M then M:=XCur+ECopy-BCopy;
                for I:=XCur to M do
                 SkrzNove(YCur,I,Nove[R,I-XCur+BCopy]);
                XCur:=M;
                if XCur<HSize then inc(XCur);
                SetBE(YCur,BText,EText)
               end
              else
               begin
                M:=HSize;
                if XCur+ECopy-BCopy<M then M:=XCur+ECopy-BCopy;
                for I:=XCur to M do
                 SkrzNove(YCur,I,Nove[R,I-XCur+BCopy]);
                XCur:=M;
                if XCur<HSize then inc(XCur);
                SetBE(YCur,BText,EText)
               end;
            end
           else Beep
          else
           case Key of
            Alt_Ins:
              if ActiveColor=Magen
               then
                begin
                 ActiveColor:=TextColor;
                 SetCursorShape(1)
                end
               else
                begin
                 ActiveColor:=Magen;
                 SetCursorShape(2)
                end;
            Alt_Home:EditRowName;
            Alt_End:EditMoveName;
            {F1:Help;}
           end;
         Hi(BackSpace):
           begin
            if (XCur>1) and (XCur<>BText)
             then
              begin
               dec(XCur);
               if (BText=EText) and (XCur=BText)
                then
                 KresliZnakBarva(' ',TextColor or $80,XCur)
               else
                begin
                 for I:=XCur to HSize-1 do
                  begin
                   SkrzNove(YCur,I,Nove[YCur,I+1]);
                   SkrzNove(YCur,HSize,$100*TextColor+ord(' '))
                  end;
                 if XCur<BText then dec(BText);
                 if XCur<=EText then dec(EText);
                end
              end
             else Beep;
           end;
         Hi(Escape):
           begin
            if EscOk
             then
              begin
               for I:=1 to HSize do
                begin
                 SkrzNove(YCur,I,LastB[I]*$100+ord(LastT[I]))
                end;
               SkrzNove(YCur,-1,Red*$100+ord(LastName));
               SkrzNove(YCur,HSize+2,LBlue*$100+ord(LastMove));
              end
             else
              begin
               for I:=1 to HSize do
                begin
                 SkrzNove(YCur,I,OldB[I]*$100+ord(OldT[I]))
                end;
               SkrzNove(YCur,-1,Red*$100+ord(OldName));
               SkrzNove(YCur,HSize+2,LBlue*$100+ord(OldMove));
               Konec:=true
              end;
            EscOK:=false;
           end;
         Hi(Enter): Konec:=true;
         else{of case}
           {if (ActiveColor<>Magen) or (ZnakNaRadek(chr(Hi(Key)),R)
           then}
            begin
             if (Flag and $04)<>0
              then
               begin
                if (XCur>=BText) or (BText<HSize) then
                 begin
                  for I:=HSize downto XCur+1 do
                   SkrzNove(YCur,I,Nove[YCur,I-1]);
                  KresliZnakBarva(chr(Hi(Key)),ActiveColor,XCur);
                  if (XCur<=EText) and (XCur>=BText) then
                   BackGroundLight(YCur,XCur);
                  if XCur<BText then inc(BText);
                  if XCur<=EText then
                   if EText<HSize then inc(EText);
                  if XCur<HSize then inc(XCur);
                 end
               end
              else
               begin
                KresliZnakBarva(chr(Hi(Key)),ActiveColor,XCur);
                if (XCur<=EText) and (XCur>=BText)
                 then BackGroundLight(YCur,XCur);
                if XCur<HSize then
                 if XCur<>EText then inc(XCur)
               end;
            end
           {else Beep;}
        end;{of case Hi(Key)}
      GotoXYCur;
      if not Konec then Key:=ReadKey
     until Konec;
     SetCursorShape(0);
    end;{with Celek}
  end;{of procedure Edit}

 Procedure Substitution(R:ShortInt;var Pos:Byte);
 var S:String;I,J:ShortInt;
 begin
  with Celek^ do
   begin
    if SubstRows[R] then
     begin
      WriteColorAt('Circular reference! '+RowNames[R]+char(13),Magen,ScreenXY);
      ScreenColorNewLine;
      Pom[0]:=chr(250);
      exit
     end
    else SubstRows[R]:=true;
    S:='';
    for I:=Barvy[R].BE to Barvy[R].EE do
     if Color3(R,I)=0 then S:=S+Texty[R,I];
    if Length(Pom)+Length(S)>=250 then
     begin
      Mywriteln('Menu error 1 - too long Dos Line, too many references');
      Pom[0]:=chr(250);
      exit
     end;
    Pom:=Copy(Pom,1,Pos)+S+Copy(Pom,Pos+1,Length(Pom)-Pos);
    for I:=Barvy[R].BE to Barvy[R].EE do
     case Color3(R,I) of
      0:inc(Pos);
      1:if ZnakNaRadek(Texty[R,I],J)
         then Substitution(J,Pos)
        else if Texty[R,I]='%' then
         begin
          S:='';inc(I);
          while (I<Barvy[R].EE) and (Texty[R,I]<>'%') and (Color3(R,I)=1) do
           begin
            S:=S+Texty[R,I];
            inc(I)
           end;
          if Texty[R,I]='%' then
           begin
            inc(I);
            S:=GetEnv(S);
            if Length(S) + Length(Pom)>=250 then
             begin
              Mywriteln('Menu error 1 - too long Dos Line, too many references');
              break
             end
            else
             begin
              Pom:=Copy(Pom,1,Pos)+S+Copy(Pom,Pos+1,Length(Pom)-Pos);
              inc(Pos,Length(S))
             end
           end
          else
           begin
            Beep;MyWriteln('Invalid Dos varialble reference :S');
           end;
          dec(I);
         end
        else
         begin
          Mywriteln(Texty[R,I]+' - Invalid reference');
          Beep
         end;
      2:;
     end;{case}
    SubstRows[R]:=false
   end;{with}
 end;

 begin { of procedure Menu}
 with Celek^ do
  begin
   ActualScreen;
   Konec:=false;
   repeat
    Key:=ReadKey;
    case Key of
     Key_Up: PosunYCur(-1);
     Key_Dn: PosunYCur(1);
     Enter,EnterNum:
               Konec:=true;
     Escape     : begin            {docasne obnoveni puvodni obrazovky}
                   Zobraz(Stare);
                   Key:=ReadKey;
                   Zobraz(Nove);
                  end;
     F1    : begin
              AllScreenBack;
              Flag:=Flag xor $20;
              ActualScreen;
             end;
     ShiftF1:if (Flag and $40)<>0 then
              begin
               AllScreenBack;
               EditHelp;
               ActualScreen;
              end;
     F2    : SaveConfig;
     CtrlF5: begin
              Posouvani;
             end;
     Key_PgDn: begin
                Flag:=Flag and $F7;
                B:=TextColor;
                SetColors;
                for I:=-1 to VSize+3 do
                 for J:=-2 to HSize+3 do
                  if (Hi(Nove[I,J]) and $7F)=B
                   then
                    SkrzNove(I,J,Nove[I,J] or $0400);
                ActiveColor:=TextColor;
               end;
     Key_PgUp: begin
                Flag:=Flag or $08;
                B:=TextColor;
                SetColors;
                for I:=-1 to VSize+3 do
                 for J:=-2 to HSize+3 do
                  if (Hi(Nove[I,J]) and $7F)=B
                   then
                    SkrzNove(I,J,Nove[I,J] and $FBFF);
                ActiveColor:=TextColor;
               end;
     AltQ,
     AltW..AltM:
                  begin
                   if ZnakNaRadek(AltNaZnak(Key),R) then
                    if R=YCur
                     then Konec:=true
                     else
                       begin
                        KresliZnakBarva(' ',TextColor,0);
                        KresliZnakBarva(' ',TextColor,HSize+1);
                        YCur:=R;
                        KresliZnakBarva(ZnakCursorL,TextColor,0);
                        KresliZnakBarva(ZnakCursorR,TextColor,HSize+1);
                        Konec:=(Flag and $08)<>0
                       end
                   else Beep
                  end;
     else  if YCur <= VSize then Edit
                            else Beep;
    end;{of case}
   until Konec;
   AllScreenBack; {obnoveni puvodni obrazovky}

   if YCur <= VSize then {upravy pro spousteni}
    begin
     UlozNove;
     for I:=1 to NumberExe do SubstRows[I]:=false;
     Pom:='';Pos:=0;
     for I:=1 to Hsize do
      if Color3(YCur,I)=0 then Pom:=Pom+Texty[YCur,I];
     for I:=1 to Hsize do
      case Color3(YCur,I) of
       0:inc(Pos);
       1:if ZnakNaRadek(Texty[YCur,I],J) then
          begin
           Substitution(J,Pos);
           if Length(Pom)>=250 then break
          end
         else if Texty[YCur,I]='%' then
          begin
           S:='';inc(I);
           while (I<Hsize) and (Texty[YCur,I]<>'%') and (Color3(YCur,I)=1) do
            begin
             S:=S+Texty[YCur,I];
             inc(I)
            end;
           if Texty[YCur,I]='%' then
            begin
             inc(I);
             S:=GetEnv(S);
             if Length(S) + Length(Pom)>=250 then
              begin
               Mywriteln('Menu error 1 - too long Dos Line, too many references');
               break
              end
             else
              begin
               Pom:=Copy(Pom,1,Pos)+S+Copy(Pom,Pos+1,Length(Pom)-Pos);
               inc(Pos,Length(S))
              end
            end
           else
            begin
             Beep;MyWriteln('Invalid Dos varialble reference :S');
            end;
           dec(I);
          end
         else
          begin
           Mywriteln(Texty[YCur,I]+' - Invalid reference');
           Beep
          end;
       2:;
      end;{case}
     if Length(Pom)>=250 then Pom:='';
     WriteColorAt(chr(13)+chr(10)+RowNames[YCur]+' ',Red,ScreenXY);
     WriteColorAt(Celek^.Pom,TextColor,ScreenXY);
     WriteColorAt(' '+MoveNames[YCur]+chr(13),LBlue,ScreenXY);
     ScreenColorNewLine;
     if ZnakNaRadek(MoveNames[YCur],R) then YCur:=R
     else
      begin
       Writeln(MoveNames[YCur]+' - Invalid move');
       Beep
      end;
    end
   else Flag:=Flag or $10 {Konec prace s menu}
  end{of with in Menu};
 end; {of procedure Menu}

begin{of program MenuWork}
 HelpOk:=false;
 CtiCelekAdr;
 SetScreenDependent;
 VytvorNove;
 Menu;{Zavola na konci AllScreenBack}
 Celek^.Pom:='/C '+Celek^.Pom
end.

